% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OWSRequest.R
\docType{class}
\name{OWSRequest}
\alias{OWSRequest}
\title{OWSRequest}
\format{\code{\link{R6Class}} object.}
\usage{
OWSRequest
}
\value{
Object of \code{\link{R6Class}} for modelling a generic OWS request
}
\description{
OWSRequest
}
\note{
Abstract class used internally by \pkg{ows4R}
}
\section{Methods}{

\describe{
 \item{\code{new(op, type, url, request, user, pwd, namedParams, attrs, 
                 contentType, mimeType, logger)}}{
   This method is used to instantiate a object for doing an OWS request
 }
 \item{\code{getRequest()}}{
   Get the request payload
 }
 \item{\code{getRequestHeaders()}}{
   Get the request headers
 }
 \item{\code{getStatus()}}{
   Get the request status code
 }
 \item{\code{getResponse()}}{
   Get the request response
 }
 \item{\code{getException()}}{
   Get the exception (in case of request failure)
 }
 \item{\code{getResult()}}{
   Get the result \code{TRUE} if the request is successful, \code{FALSE} otherwise
 }
}
}

\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{OGC}
\keyword{OWS}
\keyword{Request}
