% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trainOwl.R
\name{trainOwl}
\alias{trainOwl}
\title{Train a owl model}
\usage{
trainOwl(
  x,
  y,
  q = 0.2,
  number = 10,
  repeats = 1,
  measure = c("mse", "mae", "deviance", "missclass", "auc"),
  cl = NULL,
  ...
)
}
\arguments{
\item{x}{the feature matrix, which can be either a dense
matrix of the standard \emph{matrix} class, or a sparse matrix
inheriting from \link[Matrix:sparseMatrix]{Matrix::sparseMatrix} Data frames will
be converted to matrices internally.}

\item{y}{the response. For Gaussian models this must be numeric; for
binomial models, it can be a factor.}

\item{q}{shape of lambda sequence}

\item{number}{number of folds (cross-validation)}

\item{repeats}{number of repeats for each fold (for repeated \emph{k}-fold
cross validation)}

\item{measure}{measure to try to optimize; note that you may
supply \emph{multiple} values here and that, by default,
all the possible measures for the given model will be used.}

\item{cl}{cluster if parallel fitting is desired. Can be any
cluster accepted by \code{\link[parallel:parLapply]{parallel::parLapply()}}.}

\item{...}{other arguments to pass on to \code{\link[=owl]{owl()}}}
}
\value{
An object of class \code{"TrainedOwl"}, with the following slots:
\item{summary}{a summary of the results with means, standard errors,
and 0.95 confidence levels}
\item{data}{the raw data from the model training}
\item{optima}{a \code{data.frame} of the best (mean) values for the different metrics and their corresponding parameter values}
\item{measure}{a \code{data.frame} listing the used metrics and their labels}
\item{model}{the model fit to the entire data set}
\item{call}{the call}
}
\description{
This function trains a model fit by \code{\link[=owl]{owl()}} by tuning its parameters
through cross-validation.
}
\details{
Note that by default this method matches all of the available metrics
for the given model family against those provided in the argument
\code{measure}. Collecting these measures is not particularly demanding
computationally so it is almost always best to leave this argument
as it is and then choose which argument to focus on in the call
to \code{\link[=plot.TrainedOwl]{plot.TrainedOwl()}}.
}
\examples{
# 8-fold cross-validation repeated 5 times
tune <- trainOwl(subset(mtcars, select = c("mpg", "drat", "wt")),
                 mtcars$hp,
                 q = c(0.1, 0.2),
                 number = 8,
                 repeats = 5)
}
\seealso{
\link[parallel:parallel]{parallel::parallel}, \code{\link[=plot.TrainedOwl]{plot.TrainedOwl()}}
}
