% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sf_as_dbplyr.R
\name{sf_as_dbplyr}
\alias{sf_as_dbplyr}
\title{Registeran sf object as a DuckDB virtual table}
\usage{
sf_as_dbplyr(
  conn,
  name,
  sf_obj,
  geom_only = isFALSE(inherits(sf_obj, "sf")),
  overwrite = FALSE,
  ...
)
}
\arguments{
\item{conn}{A DuckDB connection, created by \code{dbConnect()}.}

\item{name}{The name for the virtual table that is registered or unregistered}

\item{sf_obj}{sf object to be registered to duckdb}

\item{geom_only}{if TRUE, only the geometry column is registered. Always
FALSE for sfc or sfg objects}

\item{overwrite}{Should an existing registration be overwritten?}

\item{...}{additional arguments passed to duckdb_register}
}
\value{
a \code{dbplyr} lazy table
}
\description{
A thin wrapper around \code{duckdb::duckdb_register()} that creates a virtual
table, then selects the geometry column to DuckDB.'s GEOMETRY type in the
returned \code{dbplyr} representation. Mostly useful for join and spatial
operations within DuckDB. No data is copied.
}
\details{
Behind the scenes, this function creates an initial view (\code{name}_init) with
the geometry stored as text via \code{sf::st_as_text}. It then creates the view
\code{name} which replaces the geometry column with DuckDB's internal geometry
type.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(sf)

con <- stage_conn()
sf_obj <- st_sf(a = 3, geometry = st_sfc(st_point(1:2)))
sf_as_dbplyr(con, "test", sf_obj)

DBI::dbDisconnect(con)
\dontshow{\}) # examplesIf}
}
