% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui.R
\name{useOverlay}
\alias{useOverlay}
\title{Set up a Shiny app to use overshiny}
\usage{
useOverlay()
}
\value{
Returns HTML that gets inserted into the \verb{<head>} of your app.
}
\description{
Put \code{\link[=useOverlay]{useOverlay()}} in your Shiny app's UI to use \code{overshiny}'s interactive
plot overlays.
}
\details{
This can go anywhere in your UI and it can be inserted multiple times with
no ill effect. This also calls \code{\link[shinyjs:useShinyjs]{shinyjs::useShinyjs()}}, as \code{overshiny}
depends on \code{shinyjs}.
}
\examples{
ui <- shiny::fluidPage(
    useOverlay()
    # further UI elements here . . .
)

server <- function(input, output) {
    # server code here . . .
}

if (interactive()) {
    shiny::shinyApp(ui, server)
}

}
\seealso{
\code{\link[=overlayServer]{overlayServer()}}, for a complete example.
}
