% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ouxy.r
\name{sumstat}
\alias{sumstat}
\title{Summary statistics}
\usage{
sumstat(trait = trait, tree = tree, ...)
}
\arguments{
\item{trait}{A vector of numerical trait value}

\item{tree}{An ape: tree object stored in phylo format}

\item{...}{relevent argument}
}
\value{
Twelve summary statistcs:  mean, sd, median, skewness, kurtosis from the raw data as well as from data with the difference between two closet neighbors, Bloomberg K and Pagel's lambda.
}
\description{
Calculate summary statistics given trait and tree
}
\details{
This function computes the 12 summary statistics using the trait and tree. \code{\link[ape:pic]{ape}} is used for computing the contrast trait from the difference between the species and its closet neighbor.
 For Bloomberg K and Pagel Lambda, statsitics are computed using \code{\link[phytools:phylosig]{phytools}}.
}
\examples{
library(ape)
tree<-rcoal(5)
trait <- rnorm(5)
names(trait)<-tree$tip.label
sumstat(trait=trait,tree=tree)



}
\references{
\enumerate{
  \item Paradis E. & Schliep K. 2018. ape 5.0: an environment for modern phylogenetics and evolutionary analyses in R. Bioinformatics 35: 526-528.
  \item Blomberg, Simon P., Theodore Garland Jr, and Anthony R. Ives. "Testing for phylogenetic signal in comparative data: behavioral traits are more labile." Evolution 57.4 (2003): 717-745.
  \item Pagel, Mark. "Inferring the historical patterns of biological evolution." Nature 401.6756 (1999): 877.
  \item Revell, Liam J. "phytools: an R package for phylogenetic comparative biology (and other things)." Methods in Ecology and Evolution 3.2 (2012): 217-223.
}
}
