% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssh.R
\name{server_connect}
\alias{server_connect}
\title{Connect to a server}
\usage{
server_connect(session)
}
\arguments{
\item{session}{ssh session, see \code{\link[ssh]{ssh_connect}}}
}
\value{
logical
}
\description{
Connect to a server, make accessible to \code{outsider} and
set-up for \code{outsider} interaction.
}
\details{
This requires installation of \code{ssh} package.
}
\examples{
library(outsider.base)

# NOT RUN
\dontrun{
if (requireNamespace("ssh", quietly = TRUE)) {
  session <- ssh::ssh_connect(host = '[INSERT HOST IP]')
  server_connect(session = session)
  # run outsider.base commands, when finished
  server_disconnect()
}
}
}
\seealso{
Other public-server: 
\code{\link{server_disconnect}()}
}
\concept{public-server}
