% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outliers.R
\name{outliers}
\alias{outliers}
\alias{outliers.default}
\alias{outliers.outForest}
\title{Extracts Outliers}
\usage{
outliers(object, ...)

\method{outliers}{default}(object, ...)

\method{outliers}{outForest}(object, ...)
}
\arguments{
\item{object}{An object of class 'outForest'.}

\item{...}{Arguments passed from or to other methods.}
}
\value{
A \code{data.frame} with one row per outlier. The columns are as follows:
\itemize{
  \item \code{row}, \code{col}: Row and column in original data with outlier.
  \item \code{observed}: Observed value.
  \item \code{predicted}: Predicted value.
  \item \code{rmse}: Scaling factor used to normalize the difference between observed and predicted.
  \item \code{score}: Outlier score defined as (observed-predicted)/rmse.
  \item \code{threshold}: Threshold above which an outlier score counts as outlier.
  \item \code{replacement}: Value used to replace observed value.
}
}
\description{
Extracts outliers from object of class 'outForest'. The outliers are sorted by their absolute score in descending fashion.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default method not implemented yet.

\item \code{outForest}: Extract outliers from outForest object.
}}

\examples{
x <- outForest(iris)
outliers(x)
}
