% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_github_modified.R
\name{load_github_modified}
\alias{load_github_modified}
\title{A modified version of the Rfssa load_github_data() function}
\usage{
load_github_modified(github_data_url, env)
}
\arguments{
\item{github_data_url}{The GitHub url of the .RData data set to be loaded.}

\item{env}{Environment where the data is to be loaded into.}
}
\value{
Loads the .RData into the local environment.
}
\description{
Loads .RData files directly from a GitHub repository.
The original Rfssa function (Haghbin et al., 2022) is
based on the Stack Overflow post (Hartman, 2016):
https://stackoverflow.com/questions/24846120/importing-data-into-r-rdata-from-github,
and loads the .RData to the global environment. This function
allows the user to choose the environment which the
.RData files are loaded to.
}
\examples{
\donttest{
env = environment()
load_github_modified("https://github.com/ehoward1/oulad_data/blob/main/vle.RData", env)}
}
\references{
Haghbin, H., Trinka, J., Najibi, S., M., & Maadooliat, M. (2022).
Package 'Rfssa'. https://cran.r-project.org/web/packages/Rfssa/Rfssa.pdf.

Hartman, R. (2016). Importing data into R (.rData) from Github.
https://stackoverflow.com/questions/24846120/importing-data-into-r-rdata-from-github.
}
