% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geospiza.R
\docType{data}
\name{geospiza}
\alias{geospiza}
\title{Data on Darwin's finches}
\format{
The object \code{geospiza} is a list containing:
\itemize{
\item \code{phy}, a phylogenetic tree of class 'phylo' (see \code{\link[ape]{read.tree}})
\item \code{dat}, a data frame containing data on various morphological measurements.
}
}
\source{
Data obtained from the \pkg{geiger} package, version 2.0.7.1.
It is attributed there to D. Schluter, with no other details given.
}
\description{
Morphological measurements of Darwin's finches, together with a phylogeny.
}
\examples{
### Darwin's finches.
### The data were taken from package 'geiger' due to the latter being orphaned.
if (requireNamespace("ape")) {

  data(geospiza)
  plot(geospiza$phy)
  print(geospiza$dat)
  
### make an ouchtree out of the phy-format tree
  ot <- ape2ouch(geospiza$phy)

### merge data with tree info
  otd <- as(ot,"data.frame")
  otd <- merge(otd,geospiza$dat,by.x="labels",by.y="row.names",all=TRUE)
### row-names are used by 'hansen'
  rownames(otd) <- otd$nodes
  print(otd)
### this data-frame now contains the data as well as the tree geometry

### now remake the ouch tree
  ot <- with(otd,ouchtree(nodes=nodes,ancestors=ancestors,times=times,labels=labels))
  plot(ot)

  b1 <- brown(tree=ot,data=otd[c("tarsusL","beakD")])
  summary(b1)

### evaluate an OU model with a single, global selective regime
  otd$regimes <- as.factor("global")
  h1 <- hansen(
    tree=ot,
    data=otd[c("tarsusL","beakD")],
    regimes=otd["regimes"],
    sqrt.alpha=c(1,0,1),
    sigma=c(1,0,1),
    maxit=10000
  )
  summary(h1)
  plot(h1)

}
}
\seealso{
Other examples: 
\code{\link{anolis.ssd}},
\code{\link{bimac}},
\code{\link{ouch-package}}
}
\author{
Aaron A. King, Emmanuel Paradis, Daniel Lawson
}
\concept{examples}
\keyword{models}
