% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R, R/hansen.R
\name{plot}
\alias{plot}
\alias{plot,ouchtree-method}
\alias{plot,hansentree-method}
\alias{plot-hansentree}
\title{ouch plotting functions}
\usage{
\S4method{plot}{ouchtree}(
  x,
  y,
  ...,
  regimes = NULL,
  ladderize = TRUE,
  node.names = FALSE,
  legend = TRUE,
  labels,
  frame.plot = FALSE,
  palette = rainbow,
  margin = 0.1,
  text_opts = list(),
  legend_opts = list()
)

\S4method{plot}{hansentree}(x, ..., regimes)
}
\arguments{
\item{x}{object to plot.}

\item{y}{ignored.}

\item{...}{additional arguments, passed to \code{\link[graphics]{plot}}.}

\item{regimes}{factor or character; a vector of regime paintings.}

\item{ladderize}{logical; should the tree be ladderized?}

\item{node.names}{logical; should node names be displayed?}

\item{legend}{logical; display a legend?}

\item{labels}{character; taxon labels.}

\item{frame.plot}{a logical indicating whether a box should be drawn
    around the plot.}

\item{palette}{function or character; specifies the colors to be used for the several regimes on the tree.
Specified as a function, when given an integer, \code{n}, the function should create a vector of \code{n} colors.
See, for example \code{\link[grDevices:rainbow]{rainbow}}.
One can also specify the \code{n} colors as a vector of color codes.
There must be at least as many colors as levels in the \code{regimes}.}

\item{margin}{numeric; width of the right margin (as a fraction of the plot width).
Adjust this if labels are clipped.
If different left and right margins are desired, furnish two numbers here.}

\item{text_opts}{options for the labels; passed to \code{\link[graphics]{text}}}

\item{legend_opts}{options for the the legend; passed to \code{\link[graphics]{legend}}}
}
\description{
Plot phylogenetic trees, with or without regime paintings.
}
\seealso{
Other methods: 
\code{\link{bootstrap}()},
\code{\link{coef}()},
\code{\link{logLik}},
\code{\link{print}()},
\code{\link{simulate}()},
\code{\link{summary}()},
\code{\link{update}()}
}
\concept{methods}
