% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ocp_pewma.R
\name{OcpPewma}
\alias{OcpPewma}
\title{Optimized Classic Processing Probabilistic-EWMA (PEWMA).}
\usage{
OcpPewma(data, alpha0 = 0.2, beta = 0, n.train = 5, l = 3)
}
\arguments{
\item{data}{Numerical vector with training and test datasets.}

\item{alpha0}{Maximal weighting parameter.}

\item{beta}{Weight placed on the probability of the given observation.}

\item{n.train}{Number of points of the dataset that correspond to the
training set.}

\item{l}{Control limit multiplier.}
}
\value{
dataset conformed by the following columns:

  \item{is.anomaly}{1 if the value is anomalous 0, otherwise.}
  \item{ucl}{Upper control limit.}
  \item{lcl}{Lower control limit.}
}
\description{
\code{OcpPewma} calculates the anomalies of a dataset using
an optimized version of classical processing Probabilistic-EWMA algorithm.
It Is an optimized implementation of the \code{\link{CpPewma}} algorithm
using environmental variables. It has been shown that in long datasets it can
reduce runtime by up to 50\%. TThis algorithm is a probabilistic method of
EWMA which dynamically adjusts the parameterization based on the probability
of the given observation. This method produces dynamic, data-driven anomaly
thresholds which are robust to abrupt transient changes, yet quickly adjust
to long-term distributional shifts.
}
\details{
\code{data} must be a numerical vector without NA values.
\code{alpha0} must be a numeric value where 0 < \code{alpha0} < 1. If a
faster adjustment to the initial shift is desirable, simply lowering
\code{alpha0} will suffice. \code{beta} is the weight placed on the
probability of the given observation. It must be a numeric value where
0 <= \code{beta} <= 1. Note that if \code{beta} equals 0, PEWMA converges to
a standard EWMA. Finally \code{l} is the parameter that determines the
control limits. By default, 3 is used.
}
\examples{
## Generate data
set.seed(100)
n <- 180
x <- sample(1:100, n, replace = TRUE)
x[70:90] <- sample(110:115, 21, replace = TRUE)
x[25] <- 200
x[150] <- 170
df <- data.frame(timestamp = 1:n, value = x)

## Calculate anomalies
result <- OcpPewma(
  data = df$value,
  n.train = 5,
  alpha0 = 0.8,
  beta = 0.1,
  l = 3
)

## Plot results
res <- cbind(df, result)
PlotDetections(res, title = "PEWMA ANOMALY DETECTOR")
}
\references{
M. Carter, Kevin y W. Streilein. Probabilistic reasoning for
streaming anomaly detection. 2012 IEEE Statistical Signal Processing Workshop
(SSP), pp. 377-380, Aug 2012.
}
