# <img src="man/figures/logo.jpg" align="right" width="120" />

[![CRAN_Status_Badge](https://www.r-pkg.org/badges/version/otargen?color=blue)](https://CRAN.R-project.org/package=otargen)
[![Downloads](https://cranlogs.r-pkg.org/badges/otargen?color=yellow)](https://CRAN.R-project.org/package=otargen)

## Streamline Tidy Data Access to Open Target Genetics GraphQL API🔍
`otargen` is an innovative, open-source R package for easy data retrieval and analysis from [Open Target Genetics](https://genetics.opentargets.org). It brings simplicity and power to your R environment, enhancing your research with advanced data handling and visualization tools.

### Key Features
🚀 **Effortless Data Retrieval**: Access comprehensive GraphQL query types with user-friendly functions, transforming complex queries into tidy, analysis-ready data tables.

📈 **Insightful Visualizations**: Deploy intuitive plotting functions for a clear view of complex datasets, uncovering hidden patterns and insights.

📖 **Comprehensive Documentation**: Each function is thoroughly documented, ensuring a smooth integration into your workflow and a clear understanding of the results.

👨‍💻 **Regular Updates**: Stay abreast of the latest in Open Target Genetics with our commitment to continuous improvement and feature expansion.

## Announcement :loudspeaker:

For Python users, we're excited to announce that a Python version of our package is now available! :snake: :rocket: 

Check out the repository here: [otargenpy on GitHub](https://github.com/amirfeizi/otargenpy)

This version brings the capabilities of `otargen` to the Python community, We encourage you to try it out and provide feedback!

### Community and Contributions
Join the `otargen` community on [GitHub](https://github.com/amirfeizi/otargen) and contribute to its growth. We welcome bug reports, feature suggestions, and code contributions.

### Installation
Get started with `otargen` from CRAN:
```r
install.packages("otargen")
```
Or install the latest development version from GitHub:
```
if (!require("devtools")) install.packages("devtools")
devtools::install_github("https://github.com/amirfeizi/otargen.git")
```
### Citing otargen
If you use `otargen` in your research, please cite our work. Published in [Bioinformatics](https://academic.oup.com/bioinformatics/article/39/8/btad441/7226507).
```
Feizi, Amir, and Kamalika Ray. "otargen: GraphQL-based R package for tidy data accessing and processing from Open Targets Genetics." Bioinformatics 39.8 (2023): btad441.
```

