% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variantInfo.R
\name{variantInfo}
\alias{variantInfo}
\title{Retrieves information about a variant.}
\usage{
variantInfo(variant_id)
}
\arguments{
\item{variant_id}{Character: generated ID for variants by Open Targets Genetics (e.g. 1_154119580_C_A) or rsId (rs2494663).}
}
\value{
Returns a data frame (in tibble format) containing information about the variant.
The data frame has the following structure:
\itemize{
  \item{\code{chromosome}:} \emph{Character}. Chromosome of the variant.
  \item{\code{position}:} \emph{Integer}. Position of the variant.
  \item{\code{refAllele}:} \emph{Character}. Reference allele.
  \item{\code{altAllele}:} \emph{Character}. Alternative allele.
  \item{\code{rsId}:} \emph{Character}. Variant rsID.
  \item{\code{chromosomeB37}:} \emph{Character}. Chromosome of the variant in build 37 coordinates.
  \item{\code{positionB37}:} \emph{Integer}. Position of the variant in build 37 coordinates.
  \item{\code{id}:} \emph{Character}. Variant ID.
  \item{\code{nearestGene.id}:} \emph{Character}. ID of the nearest gene to the variant.
  \item{\code{nearestGene.symbol}:} \emph{Character}. Symbol of the nearest gene to the variant.
  \item{\code{nearestGeneDistance}:} \emph{Integer}. Distance to the nearest gene.
  \item{\code{nearestCodingGene.id}:} \emph{Character}. ID of the nearest coding gene to the variant.
  \item{\code{nearestCodingGene.symbol}:} \emph{Character}. Symbol of the nearest coding gene to the variant.
  \item{\code{nearestCodingGeneDistance}:} \emph{Integer}. Distance to the nearest coding gene.
  \item{\code{mostSevereConsequence}:} \emph{Character}. Most severe consequence of the variant.
  \item{\code{caddRaw}:} \emph{Numeric}. CADD raw score.
  \item{\code{caddPhred}:} \emph{Numeric}. CADD phred score.
  \item{\code{gnomadAFR}:} \emph{Numeric}. Allele frequency in the African/African-American population in gnomAD.
  \item{\code{gnomadAMR}:} \emph{Numeric}. Allele frequency in the Latino/Admixed American population in gnomAD.
  \item{\code{gnomadASJ}:} \emph{Numeric}. Allele frequency in the Ashkenazi Jewish population in gnomAD.
  \item{\code{gnomadEAS}:} \emph{Numeric}. Allele frequency in the East Asian population in gnomAD.
  \item{\code{gnomadFIN}:} \emph{Numeric}. Allele frequency in the Finnish population in gnomAD.
  \item{\code{gnomadNFE}:} \emph{Numeric}. Allele frequency in the Non-Finnish European population in gnomAD.
  \item{\code{gnomadNFEEST}:} \emph{Numeric}. Allele frequency in the Estonian population in gnomAD.
  \item{\code{gnomadNFENWE}:} \emph{Numeric}. Allele frequency in the Northwest European population in gnomAD.
  \item{\code{gnomadNFESEU}:} \emph{Numeric}. Allele frequency in the Southern European population in gnomAD.
  \item{\code{gnomadNFEONF}:} \emph{Numeric}. Allele frequency in the Other Non-Finnish European population in gnomAD.
  \item{\code{gnomadOTH}:} \emph{Numeric}. Allele frequency in other populations in gnomAD.
}
}
\description{
For a given variant ID, this function retrieves information about the variant, including its chromosome,
position, reference allele, alternative allele, rsID, nearest gene, most severe consequence, and allele
frequencies in different populations from gnomAD databse. The Genome Aggregation Database (gnomAD) is a
resource developed by an international coalition of investigators, with the goal of aggregating and
harmonizing both exome and genome sequencing data from a wide variety of large-scale sequencing projects,
and making summary data available for the wider scientific community (see the reference).
}
\examples{
\dontrun{
result <- variantInfo(variant_id = "rs123456")
}

}
\references{
https://gnomad.broadinstitute.org/
}
