% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/studyInfo.R
\name{studyInfo}
\alias{studyInfo}
\title{Retrieve study summary information.}
\usage{
studyInfo(study_id)
}
\arguments{
\item{study_id}{Character:  Study ID(s) generated by Open Targets Genetics (e.g GCST90002357).}
}
\value{
Returns a data frame (in tibble format) containing the summary iformation about a GWAS study. The data frame has the following data structure:
\itemize{
  \item{\code{studyId}:} \emph{Character}. Study ID.
  \item{\code{traitReported}:} \emph{Character}. Reported trait.
  \item{\code{source}:} \emph{Character}. Source.
  \item{\code{traitEfos}:} \emph{Character}. Trait EFO ID.
  \item{\code{pmid}:} \emph{Character}. PubMed ID.
  \item{\code{pubDate}:} \emph{Character}. Publication date.
  \item{\code{pubJournal}:} \emph{Character}. Publication journal.
  \item{\code{pubTitle}:} \emph{Character}. Publication title.
  \item{\code{pubAuthor}:} \emph{Character}. Publication author.
  \item{\code{hasSumstats}:} \emph{Character}. Indicates if the study has summary statistics.
  \item{\code{ancestryInitial}:} \emph{Character}. Initial ancestry.
  \item{\code{nInitial}:} \emph{Character}. Initial sample size.
  \item{\code{nReplication}:} \emph{Character}. Replication sample size.
  \item{\code{traitCategory}:} \emph{Character}. Trait category.
  \item{\code{numAssocLoci}:} \emph{Character}. Number of associated loci.
  \item{\code{nTotal}:} \emph{Character}. Total sample size.
}
}
\description{
For a given study id, this function returns a data frame of relevant information about
the GWAS study, such as PubMed ID, studied trait EFO ID, case/control size, etc.
}
\examples{
\dontrun{
result <- studyInfo(study_id = "GCST90002357")
}
}
