% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osrmIsochrone.R
\name{osrmIsochrone}
\alias{osrmIsochrone}
\title{Get Polygons of Isochrones}
\usage{
osrmIsochrone(
  loc,
  breaks = seq(from = 0, to = 60, length.out = 7),
  exclude = NULL,
  res = 30,
  returnclass = "sp",
  osrm.server = getOption("osrm.server"),
  osrm.profile = getOption("osrm.profile")
)
}
\arguments{
\item{loc}{a numeric vector of longitude and latitude (WGS84), an sf object, 
a SpatialPointsDataFrame or a SpatialPolygonsDataFrame of the origine point.}

\item{breaks}{a numeric vector of isochrone values (in minutes).}

\item{exclude}{pass an optional "exclude" request option to the OSRM API.}

\item{res}{number of points used to compute isochrones, one side of the square 
grid, the total number of points will be res*res.}

\item{returnclass}{class of the returned polygons. Either "sp" of "sf".}

\item{osrm.server}{the base URL of the routing server.
getOption("osrm.server") by default.}

\item{osrm.profile}{the routing profile to use, e.g. "car", "bike" or "foot"
(when using the routing.openstreetmap.de test server).
getOption("osrm.profile") by default.}
}
\value{
A SpatialPolygonsDateFrame or an sf MULTIPOLYGON of isochrones is returned. 
The data frame of the output contains four fields: 
id (id of each polygon), min and max (minimum and maximum breaks of the polygon), 
center (central values of classes).
}
\description{
Based on \code{\link{osrmTable}}, this function buids polygons 
 of isochrones.
}
\examples{
\dontrun{
# Load data
library(sf)
data("berlin")
# Get isochones with lon/lat coordinates
iso <- osrmIsochrone(loc = c(13.43,52.47), breaks = seq(0,14,2),
                     returnclass="sf")
plot(st_geometry(iso), col = c('grey80','grey60','grey50',
                               'grey40','grey30','grey20'))
# Map
if(require("mapsf")){
  breaks <- sort(c(unique(iso$min), max(iso$max)))
  mapsf::mf_map(x = iso, var = "center", type = "choro", 
                breaks = breaks, pal = "Greens",
                border = NA, leg_pos = "topleft",
                leg_frame = TRUE, leg_title = "Isochrones\n(min)")
}

# Get isochones with an sf POINT
iso2 <- osrmIsochrone(loc = apotheke.sf[10,], returnclass="sf",
                      breaks = seq(from = 0, to = 16, by = 2))
# Map
if(require("mapsf")){
  breaks2 <- sort(c(unique(iso2$min), max(iso2$max)))
  mapsf::mf_map(x = iso2, var = "center", type = "choro", 
                breaks = breaks2, pal = "Blues",
                border = NA, leg_pos = "topleft", leg_val_rnd = 0,
                leg_frame = TRUE, leg_title = "Isochrones\n(min)")
}
}
}
\seealso{
\link{osrmTable}
}
