% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opq.R
\name{add_osm_features}
\alias{add_osm_features}
\title{Add multiple features to an Overpass query}
\usage{
add_osm_features(opq, features, bbox = NULL)
}
\arguments{
\item{opq}{An \code{overpass_query} object}

\item{features}{Character vector of key-value pairs with keys and values
enclosed in escape-formatted quotations (see examples).}

\item{bbox}{optional bounding box for the feature query; must be set if no
opq query bbox has been set}
}
\value{
\link{opq} object
}
\description{
Alternative version of \link{add_osm_feature} for creating single queries
with multiple features. Key-value matching may be controlled by using
the filter symbols described in
\url{https://wiki.openstreetmap.org/wiki/Overpass_API/Overpass_QL#By_tag_.28has-kv.29}.
}
\examples{
\dontrun{
q <- opq ("portsmouth usa") \%>\%
     add_osm_features (features = c ("\"amenity\"=\"restaurant\"",
                                     "\"amenity\"=\"pub\""))
# This extracts in a single query the same result as the following:
q1 <- opq ("portsmouth usa") \%>\%
                add_osm_feature(key = "amenity",
                                value = "restaurant")
q2 <- opq ("portsmouth usa") \%>\%
                add_osm_feature(key = "amenity", value = "pub")
c (osmdata_sf (q1), osmdata_sf (q2)) # all restaurants OR pubs
}
}
\references{
\url{https://wiki.openstreetmap.org/wiki/Map_Features}
}
