% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{oscar.binarize}
\alias{oscar.binarize}
\title{Binary logical indicator matrix representation of an oscar object's coefficients (zero vs. non-zero, i.e. feature inclusion)}
\usage{
oscar.binarize(fit, kmax = fit@kmax)
}
\arguments{
\item{fit}{Fit oscar-model object}

\item{kmax}{Create matrix until kmax-value; by default same as for fit object, but for high dimensional tasks one may wish to reduce this}
}
\value{
A binary logical indicator matrix of variables (rows) as a function of cardinality k (columns), where elements are binary indicators for 1 as non-zero and 0 as zero.
}
\description{
Create a sparse matrix with binary indicator 1 indicating that a coefficient was non-zero, and value 0 (or . in sparse matrix) indicating that a coefficient was zero (i.e. feature not included)
}
\details{
The matrix consists of TRUE/FALSE values, and is very similar to the oscar.sparsify, where the function provides estimate values in a sparse matrix format.
}
\examples{
if(interactive()){
  data(ex)
  fit <- oscar(x=ex_X, y=ex_Y, k=ex_K, w=ex_c, family='cox')
  oscar.binarize(fit, kmax=5)
}

}
