% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CP_SIR.r
\name{CP_SIR}
\alias{CP_SIR}
\title{Counting process based sliced inverse regression model}
\usage{
CP_SIR(x, y, censor, bw = silverman(1, length(y)))
}
\arguments{
\item{x}{A matrix for features (continuous only).}

\item{y}{A vector of observed time.}

\item{censor}{A vector of censoring indicator.}

\item{bw}{Kernel bandwidth for nonparametric estimations (one-dimensional), the default is using Silverman's formula.}
}
\value{
A list consisting of
\item{values}{The eigenvalues of the estimation matrix}
\item{vectors}{The estimated directions, ordered by eigenvalues}
}
\description{
The CP-SIR model for right-censored survival outcome. This model is correct only under very strong assumptions, however, since it only requires an SVD, the solution is used as the initial value in the orthoDr optimization.
}
\examples{
# generate some survival data
set.seed(1)
N = 350
P = 6
dataX = matrix(rnorm(N*P), N, P)
failEDR = as.matrix(cbind(c(1, 1, 0, 0, 0, 0, rep(0, P-6)),
                          c(0, 0, 1, -1, 0, 0, rep(0, P-6))))
censorEDR = as.matrix(c(0, 1, 0, 1, 1, 1, rep(0, P-6)))
T = exp(-2.5 + dataX \%*\% failEDR[,1] +
    0.5*(dataX \%*\% failEDR[,1])*(dataX \%*\% failEDR[,2]) + 0.25*log(-log(1-runif(N))))
C = exp( -0.5 + dataX \%*\% censorEDR  + log(-log(1-runif(N))))
Y = pmin(T, C)
Censor = (T < C)

# fit the model
CP_SIR.fit = CP_SIR(dataX, Y, Censor)

# compare with the true direction
distance(failEDR, CP_SIR.fit$vectors[, 1:2], "dist")
}
\references{
Sun, Q., Zhu, R., Wang T. and Zeng D. "Counting Process Based Dimension Reduction Method for Censored Outcomes." (2017)
\url{https://arxiv.org/abs/1704.05046} .
}
