% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{performPermutation}
\alias{performPermutation}
\title{Transform array with orthogonal permutation matrix}
\usage{
performPermutation(T, real.dimensions, data, verbose = FALSE)
}
\arguments{
\item{T}{is an orthogonal matrix.}

\item{real.dimensions}{is a one-dimensional array, representing the length
of dimensions in data.}

\item{data}{is a one-dimensional representation of the data to be
transformed.}

\item{verbose}{is a logical variable (default = \code{FALSE}) that allows
text-based feedback during execution of the function.}
}
\description{
Given an orthogonal permutation matrix \eqn{T}, an array of
dimensions and a one-dimensional representation of data.  It will return a
transformed array with the transformed dimensions.
}
\details{
This function is mainly used by the \code{\link{reorient}} function
to transform nifti data into neuroradiological convention.
}
\seealso{
\code{\link{reorient}},\code{\link{inverseReorient}}
}
\author{
Andrew Thornton \email{zeripath@users.sourceforge.net}
}
