% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ocmm.methods.R
\name{vcov.ocmm}
\alias{vcov.ocmm}
\title{Variance-Covariance Matrix for a Fitted Continuous Ordinal Mixed Model Object}
\usage{
\method{vcov}{ocmm}(object, ...)
}
\arguments{
\item{object}{an \code{ocmm} object}

\item{...}{further arguments to be passed to methods}
}
\value{
Variance-covariance matrix of model parameters
}
\description{
Calculates variance-covariance matrix for a fitted \code{ocmm} object
}
\details{
For the generalized logistic g-function, the variance-covariance matrix of model parameters is
of dimension (\code{len_beta} +4)x(\code{len_beta} +4), where \code{len_beta}  is the number of
beta coefficients in the model.
}
\examples{
\dontrun{
fit.overall.rnd  <- ocmm(overall  ~ cycleno + age + bsa + treatment + (1|randno), data=ANZ0001)
vcov(fit.overall.rnd)
}
}
\author{
Maurizio Manuguerra, Gillian Heller
}
\seealso{
\code{\link{ocmm}}
}

