% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ocm.methods.R
\name{predict.ocm}
\alias{predict.ocm}
\title{Predict method for Continuous Ordinal Fits}
\usage{
\method{predict}{ocm}(object, newdata = NULL, ndens = 100, ...)
}
\arguments{
\item{object}{an object of class \code{ocm}, usually a result of a call to \code{ocm}}

\item{newdata}{optionally, a data frame in which to look for variables with
which to predict.
Note that all predictor variables should be present, having the same names as the variables
used to fit the model. If \code{NULL}, predictions are computed for the original dataset.}

\item{ndens}{the number of points on the continuous ordinal scale (0, 1) over which the densities are computed.
The default is 100.}

\item{...}{further arguments passed to or from other methods}
}
\value{
A list containing the following components:
\item{mode}{a vector of length equal to the number of observations.
Each element is the mode of \code{v},
the  continuous ordinal random variable, conditional on the covariates in the model.}
\item{density}{a matrix with number of rows equal to the number of observations. Each row
contains the values of the density function of \code{v} conditional on the covariates in the
model.
The density function is calculated over \code{ndens} equally-spaced values of v in (0,1).}
\item{x}{a vector with the \code{ndens} equally-spaced values of \code{v} in (0,1) used to compute the
density of v}
\item{formula}{the formula used to fit the model}
\item{newdata}{a new data frame used to make predictions. It takes value NULL if no new data frame has been used.}
}
\description{
Predicted values based on \code{ocm} object
}
\details{
An object of class \code{ocm} and optionally a new data
frame are used to compute the probability
densities of \code{v}, the continuous ordinal score. The estimated parameters
of the fitted model and \code{ndens} (default: 100)
values of \code{v} are used to compute the probability densities on the latent scale.
These values are then transformed to scores on the continuous ordinal
scale using the g function and the estimated values
of \code{M}, \code{B}, and \code{T}.
}
\examples{
ANZ0001.ocm <- ANZ0001[ANZ0001$cycleno==0 | ANZ0001$cycleno==5,]
ANZ0001.ocm$cycleno[ANZ0001.ocm$cycleno==5] <- 1
fit.overall <- ocm(overall ~ cycleno + age + bsa + treatment, data=ANZ0001.ocm)
pred <- predict(fit.overall)
plot(pred)
}
\author{
Maurizio Manuguerra, Gillian Heller
}
\seealso{
\code{\link{ocm}}, \code{\link{plot.predict.ocm}}
}
\keyword{predict}

