% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{orderly_latest}
\alias{orderly_latest}
\title{Find most recent report}
\usage{
orderly_latest(
  name = NULL,
  root = NULL,
  locate = TRUE,
  draft = FALSE,
  must_work = TRUE
)
}
\arguments{
\item{name}{Name of the report to find; if \code{NULL} returns the
most recent report across all names}

\item{root}{The path to an orderly root directory, or \code{NULL}
(the default) to search for one from the current working
directory if \code{locate} is \code{TRUE}.}

\item{locate}{Logical, indicating if the configuration should be
searched for.  If \code{TRUE} and \code{config} is not given,
then orderly looks in the working directory and up through its
parents until it finds an \code{orderly_config.yml} file.}

\item{draft}{Should draft reports be used searched? Valid values
are logical (\code{TRUE}, \code{FALSE}) or use the string
\code{newer} to use draft reports where they are newer than
archive reports. For consistency, \code{always} and \code{never}
are equivalent to \code{TRUE} and \code{FALSE}, respectively.}

\item{must_work}{Throw an error if no report is found.  If \code{FALSE},
returns \code{NA_character_}.}
}
\value{
A character string with the id of the most recent report
}
\description{
Find most recent version of an orderly report.  The most recent
report is always the most recently run report that has been
committed (regardless of the order in which they were committed).
}
\examples{
path <- orderly::orderly_example("minimal")
id1 <- orderly::orderly_run("example", root = path, echo = FALSE)
id2 <- orderly::orderly_run("example", root = path, echo = FALSE)

# With no reports committed there is no latest report:
orderly::orderly_latest("example", root = path, must_work = FALSE)

# Commit the first report and it will be reported as latest:
orderly::orderly_commit(id1, root = path)
orderly::orderly_latest("example", root = path)

# Commit the second report and it will be reported as latest instead:
orderly::orderly_commit(id2, root = path)
orderly::orderly_latest("example", root = path)
}
\seealso{
\link{orderly_list} and
\link{orderly_list_archive} for listing report names and
versions.
}
