% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db.R
\name{orderly_db}
\alias{orderly_db}
\title{Connect to orderly databases}
\usage{
orderly_db(type, root = NULL, locate = TRUE, validate = TRUE, instance = NULL)
}
\arguments{
\item{type}{The type of connection to make (\code{source},
\code{destination}, \code{csv} or \code{rds}).}

\item{root}{The path to an orderly root directory, or \code{NULL}
(the default) to search for one from the current working
directory if \code{locate} is \code{TRUE}.}

\item{locate}{Logical, indicating if the configuration should be
searched for.  If \code{TRUE} and \code{config} is not given,
then orderly looks in the working directory and up through its
parents until it finds an \code{orderly_config.yml} file.}

\item{validate}{Logical, indicating if the database schema should
be validated on open (currently only applicable with \code{type
= "destination"}).  This is primarily intended for internal use.}

\item{instance}{Used only by \code{type = "source"}, and used to
select the instance, where multiple instances are configured.
Use a single \emph{unnamed} character string to indicate an
instance to match.  If given, then this name must be present in
all databases where instances are listed in
\code{orderly_config.yml}, and will be ignored by all database
where instances are not given.  See the "orderly" vignette for
further information.}
}
\value{
A database connection, or list of connections in the case
  of \code{source}.
}
\description{
Connect to the orderly databases.  These should be treated as as
\emph{read-only}.
}
\details{
Orderly has several databases:

\describe{

\item{source}{All of the databases named in the \code{database}
  section of the \code{orderly_config.yml}}

\item{destination}{The orderly index database (typically a SQLite
database stored at the orderly root)}

\item{csv}{The cache of database query results, in csv format}

\item{rds}{The cache of database query results, in rds format}

}
}
\examples{
# Create an orderly that has a single commited report:
path <- orderly::orderly_example("minimal")
id <- orderly::orderly_run("example", root = path)
orderly::orderly_commit(id, root = path)

# The source database holds the data that might be accessible via
# the 'data' entry in orderly.yml:
db <- orderly::orderly_db("source", root = path)
# This is a list, with one connection per database listed in the
# orderly_config.yml (an empty list if none are specified):
db
DBI::dbListTables(db$source)
head(DBI::dbReadTable(db$source, "data"))
DBI::dbDisconnect(db$source)

# The destination database holds information about the archived
# reports:
db <- orderly::orderly_db("destination", root = path)
DBI::dbListTables(db)

# These tables are documented online:
# https://vimc.github.io/orderly/schema
DBI::dbReadTable(db, "report_version")
}
