% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.strat.R
\name{plot.strat}
\alias{plot.strat}
\title{Plot diagnostics for a "strat" object}
\usage{
\method{plot}{strat}(
  x,
  incl_none = TRUE,
  incl_base = TRUE,
  by_strata = FALSE,
  weighted_avg = FALSE,
  legend = c("No strata", "Base strata", "Refined strata"),
  ...
)
}
\arguments{
\item{x}{object of S3 class 'strat'}

\item{incl_none}{whether to plot imbalances before any stratification}

\item{incl_base}{whether to plot imbalances for the base stratification (if one exists)}

\item{by_strata}{whether to generate a list of plots, one for each base stratum if
\code{incl_base} is \code{TRUE}, or one for each refined stratum if \code{incl_base} is \code{FALSE}.
Not used if \code{incl_none} is \code{TRUE}}

\item{weighted_avg}{whether to take the weighted average instead of the straight average
when collapsing standardized mean differences across strata. Default is \code{FALSE}}

\item{legend}{a vector of labels to use for the three stratifications on the plot.
The corresponding label for any stratification that is not to be plotted must
still be provided but will be ignored and
can be set to \code{NA}}

\item{...}{further arguments passed to or from other methods}
}
\value{
Either a ggplot object for the Love plot of standardized mean differences or
a list of such ggplot objects if \code{by_strata} is \code{TRUE}
}
\description{
Plots the standardized mean differences for \code{strat} objects in the format of Love (2002).
}
\examples{
# Choose 800 patients and 5 covariates to work with for the example
set.seed(28)
samp <- sample(1:nrow(rhc_X), 800)
cov_samp <- sample(1:26, 5)
ref <- refine(X = rhc_X[samp, cov_samp], z = rhc_X[samp, "z"])
plot(ref)

}
\references{
Love, T. E. (2002), "Displaying covariate balance after adjustment for selection bias",
Joint Statistical Meetings, yumpu.com/en/document/read/41664623.
}
