% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimizer.R
\name{apply_optimizer}
\alias{apply_optimizer}
\title{Optimization}
\usage{
apply_optimizer(optimizer = optimizer_nlm(), f, p, ...)
}
\arguments{
\item{optimizer}{An object of class \code{optimizer}.}

\item{f}{The \code{function} to be optimized, returning a single \code{numeric}.
Its first argument must be a \code{numeric} vector of the length of \code{p},
followed by any other arguments specified by the \code{...} argument.}

\item{p}{A \code{numeric} vector with starting parameter values for the optimization.}

\item{...}{Additional arguments to be passed to \code{f}.}
}
\value{
A named \code{list}, containing the elements
\itemize{
\item \code{v}, the value of the estimated optimum of \code{f},
\item \code{z}, the parameter vector where the optimum of \code{f} is obtained,
\item \code{time}, the total optimization time (as a \code{difftime} object),
\item and additional output elements of the optimizer (if not excluded by the
\code{out_ign} element via \code{\link{set_optimizer}}).
}
}
\description{
This function performs numerical optimization using an \code{optimizer}
object.
}
\examples{
apply_optimizer(optimizer_nlm(), function(x) -(x + 1)^2 + 1, 2)
}
\seealso{
\code{\link[=set_optimizer]{set_optimizer()}} for specifying an \code{optimizer} object.
}
