% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_add_dxfs_style}
\alias{wb_add_dxfs_style}
\title{Set a dxfs styling for the workbook}
\usage{
wb_add_dxfs_style(
  wb,
  name,
  font_name = NULL,
  font_size = NULL,
  font_color = NULL,
  num_fmt = NULL,
  border = NULL,
  border_color = wb_color(getOption("openxlsx2.borderColor", "black")),
  border_style = getOption("openxlsx2.borderStyle", "thin"),
  bg_fill = NULL,
  gradient_fill = NULL,
  text_bold = NULL,
  text_italic = NULL,
  text_underline = NULL,
  ...
)
}
\arguments{
\item{wb}{A Workbook object.}

\item{name}{the style name}

\item{font_name}{the font name}

\item{font_size}{the font size}

\item{font_color}{the font color (a \code{wb_color()} object)}

\item{num_fmt}{the number format}

\item{border}{logical if borders are applied}

\item{border_color}{the border color}

\item{border_style}{the border style}

\item{bg_fill}{any background fill}

\item{gradient_fill}{any gradient fill}

\item{text_bold}{logical if text is bold}

\item{text_italic}{logical if text is italic}

\item{text_underline}{logical if text is underlined}

\item{...}{additional arguments passed to \code{\link[=create_dxfs_style]{create_dxfs_style()}}}
}
\value{
The Workbook object, invisibly
}
\description{
These styles are used with conditional formatting and custom table styles.
}
\examples{
wb <- wb_workbook() \%>\%
  wb_add_worksheet() \%>\%
  wb_add_dxfs_style(
   name = "nay",
   font_color = wb_color(hex = "FF9C0006"),
   bg_fill = wb_color(hex = "FFFFC7CE")
  )
}
\seealso{
Other workbook styling functions: 
\code{\link{base_font-wb}},
\code{\link{wb_add_style}()}
}
\concept{workbook styling functions}
