% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wb_functions.R
\name{select_active_sheet}
\alias{select_active_sheet}
\alias{wb_get_active_sheet}
\alias{wb_set_active_sheet}
\alias{wb_get_selected}
\alias{wb_set_selected}
\title{get and set table of sheets and their state as selected and active}
\usage{
wb_get_active_sheet(wb)

wb_set_active_sheet(wb, sheet)

wb_get_selected(wb)

wb_set_selected(wb, sheet)
}
\arguments{
\item{wb}{a workbook}

\item{sheet}{a sheet name of the workbook}
}
\value{
a data frame with tabSelected and names
}
\description{
Multiple sheets can be selected, but only a single one can be
active (visible). The visible sheet, must not necessarily be a selected
sheet.
}
\examples{
  wb <- wb_load(file = system.file("extdata", "loadExample.xlsx", package = "openxlsx2"))
  # testing is the selected sheet
  wb_get_selected(wb)
  # change the selected sheet to IrisSample
  wb <- wb_set_selected(wb, "IrisSample")
  # get the active sheet
  wb_get_active_sheet(wb)
  # change the selected sheet to IrisSample
  wb <- wb_set_active_sheet(wb, sheet = "IrisSample")
}
