% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{showGridLines}
\alias{showGridLines}
\title{Set worksheet gridlines to show or hide.}
\usage{
showGridLines(wb, sheet, showGridLines = FALSE)
}
\arguments{
\item{wb}{A workbook object}

\item{sheet}{A name or index of a worksheet}

\item{showGridLines}{A logical. If \code{TRUE}, grid lines are hidden.}
}
\description{
Set worksheet gridlines to show or hide.
}
\examples{
wb <- loadWorkbook(file = system.file("extdata", "loadExample.xlsx", package = "openxlsx"))
names(wb) ## list worksheets in workbook
showGridLines(wb, 1, showGridLines = FALSE)
showGridLines(wb, "testing", showGridLines = FALSE)
\dontrun{
saveWorkbook(wb, "showGridLinesExample.xlsx", overwrite = TRUE)
}
}
\author{
Alexander Walker
}
