% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openxlsx.R
\docType{package}
\name{openxlsx}
\alias{openxlsx}
\alias{openxlsx-package}
\title{xlsx reading, writing and editing.}
\description{
openxlsx simplifies the the process of writing and styling Excel xlsx files from R
and removes the dependency on Java.
}
\details{
The openxlsx package uses global options to simplify formatting:

\itemize{
   \item{\code{options("openxlsx.borderColour" = "black")}}
   \item{\code{options("openxlsx.borderStyle" = "thin")}}
   \item{\code{options("openxlsx.dateFormat" = "mm/dd/yyyy")}}
   \item{\code{options("openxlsx.datetimeFormat" = "yyyy-mm-dd hh:mm:ss")}}
   \item{\code{options("openxlsx.numFmt" = NULL)}}
   \item{\code{options("openxlsx.paperSize" = 9)}} ## A4
   \item{\code{options("openxlsx.orientation" = "portrait")}} ## page orientation
} 
 See the Formatting vignette for examples. 




Additional options

\itemize{
\item{\code{options("openxlsx.compressionLevel" = "9")}} ## set zip compression level, default is "1".
}
}
\seealso{
\itemize{
   \item{\code{vignette("Introduction", package = "openxlsx")}}
   \item{\code{vignette("formatting", package = "openxlsx")}}
   \item{\code{\link{writeData}}}
   \item{\code{\link{writeDataTable}}}
   \item{\code{\link{write.xlsx}}}
   \item{\code{\link{read.xlsx}}}
  } 
for examples
}
