% Generated by roxygen2 (4.0.1): do not edit by hand
\name{worksheetOrder}
\alias{worksheetOrder}
\alias{worksheetOrder<-}
\title{Order of worksheets in xlsx file}
\usage{
worksheetOrder(wb)

worksheetOrder(wb) <- value
}
\arguments{
\item{wb}{A workbook object}

\item{value}{Vector specifying order to write worksheets to file}
}
\description{
Order of worksheets in xlsx file
}
\details{
This function does not reorder the worksheets within the workbook object, it simply
shuffles the order when writing to file.
}
\examples{
## setup a workbook with 3 worksheets
wb <- createWorkbook()
addWorksheet(wb = wb, sheetName = "Sheet 1", gridLines = FALSE)
writeDataTable(wb = wb, sheet = 1, x = iris)

addWorksheet(wb = wb, sheetName = "mtcars (Sheet 2)", gridLines = FALSE)
writeData(wb = wb, sheet = 2, x = mtcars)

addWorksheet(wb = wb, sheetName = "Sheet 3", gridLines = FALSE)
writeData(wb = wb, sheet = 3, x = Formaldehyde)

worksheetOrder(wb)
names(wb)
worksheetOrder(wb) <- c(1,3,2) # switch position of sheets 2 & 3
writeData(wb, 2, 'This is still the "mtcars" worksheet', startCol = 15)
worksheetOrder(wb)
names(wb)  ## ordering within workbook is not changed

saveWorkbook(wb, "worksheetOrderExample.xlsx",  overwrite = TRUE)
worksheetOrder(wb) <- c(3,2,1)
saveWorkbook(wb, "worksheetOrderExample2.xlsx",  overwrite = TRUE)
}

