% Generated by roxygen2 (4.0.1): do not edit by hand
\name{write.xlsx}
\alias{write.xlsx}
\title{write directly to an xlsx file}
\usage{
write.xlsx(x, file, ...)
}
\arguments{
\item{x}{data to write to file}

\item{file}{xlsx file name}

\item{...}{optional parameters to pass to functions:
\itemize{
  \item{createWorkbook}
  \item{addWorksheet}
  \item{writeData}
  \item{saveWorkbook}
}

see details.}
}
\value{
A workbook object
}
\description{
write directly to an xlsx file
}
\details{
Optional parameters are:
\itemize{
  \item{\bold{creator}}{ A string specifying the workbook author}
  \item{\bold{sheetName}}{ Name of the worksheet}
  \item{\bold{gridLines}}{ A logical. If FALSE, the worksheet grid lines will be hidden.}
  \item{\bold{startCol}}{ A vector specifiying the starting columns(s) to write df}
  \item{\bold{startRow}}{ A vector specifiying the starting row(s) to write df}
  \item{\bold{xy}}{ An alternative to specifying startCol and startRow individually.
 A vector of the form c(startCol, startRow)}
  \item{\bold{colNames or col.names}}{ If TRUE, column names of x are written.}
  \item{\bold{rowNames or row.names}}{ If TRUE, row names of x are written.}
  \item{\bold{headerStyle}}{ Custom style to apply to column names.}
  \item{\bold{borders}}{ Either "surrounding", "columns" or "rows" or NULL.  If "surrounding", a border is drawn around the
data.  If "rows", a surrounding border is drawn a border around each row. If "columns", a surrounding border is drawn with a border
between each column.}
  \item{\bold{borderColour}}{ Colour of cell border}
  \item{\bold{borderStyle}}{ Border line style.}
  \item{\bold{overwrite}}{ Overwrite existing file (Defaults to TRUE as with write.table)}
}

columns of x with class Date, POSIXct of POSIXt are automatically
styled as dates.
}
\examples{
## write to working directory
write.xlsx(iris, file = "writeXLSX1.xlsx", colNames = TRUE, borders = "rows")
write.xlsx(iris, file = "writeXLSX2.xlsx", colNames = TRUE, borders = "columns",
 borderStyle = "dashed")

options("openxlsx.borderColour" = "#4F80BD") ## set default border colour
write.xlsx(iris, file = "writeXLSX3.xlsx", colNames = TRUE, borders = "rows",
 sheetName = "Iris data", gridLines = FALSE)

options("openxlsx.borderStyle" = "dashDot")
write.xlsx(iris, file = "writeXLSX4.xlsx", colNames = TRUE, borders = "rows",
 gridLines = FALSE)

options("openxlsx.borderStyle" = "medium")
hs <- createStyle(textDecoration = "BOLD", fontColour = "#FFFFFF", fontSize=12,
 fontName="Arial Narrow", fgFill = "#4F80BD")

write.xlsx(iris, file = "writeXLSX5.xlsx", colNames = TRUE, borders = "rows",
 headerStyle = hs)
}
\author{
Alexander Walker
}
\seealso{
\code{\link{addWorksheet}}

\code{\link{writeData}}

\code{\link{createStyle}} for style parameters
}

