% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-mammals.R
\docType{data}
\name{mammals}
\alias{mammals}
\title{Sleep in Mammals}
\format{
A data frame with 62 observations on the following 11 variables.
\describe{
\item{species}{Species of mammals}
\item{body_wt}{Total body weight of the mammal (in kg)}
\item{brain_wt}{Brain weight of the mammal (in kg)}
\item{non_dreaming}{Number of hours of non dreaming sleep}
\item{dreaming}{Number of hours of dreaming sleep}
\item{total_sleep}{Total number of hours of sleep}
\item{life_span}{Life span (in years)}
\item{gestation}{Gestation time (in days)}
\item{predation}{An index of how likely the mammal is to be preyed upon.
1 = least likely to be preyed upon. 5 = most likely to be preyed upon.}
\item{exposure}{An index of the how exposed the mammal is during sleep.
1 = least exposed (e.g., sleeps in a well-protected den). 5 = most exposed.}
\item{danger}{An index of how much danger the mammal
faces from other animals. This index is based upon Predation and Exposure. 1
= least danger from other animals. 5 = most danger from other animals.}
}
}
\source{
\url{http://www.statsci.org/data/general/sleep.txt}
}
\usage{
mammals
}
\description{
This data set includes data for 39 species of mammals distributed over 13
orders. The data were used for analyzing the relationship between
constitutional and ecological factors and sleeping in mammals. Two
qualitatively different sleep variables (dreaming and non dreaming) were
recorded. Constitutional variables such as life span, body weight, brain
weight and gestation time were evaluated. Ecological variables such as
severity of predation, safety of sleeping place and overall danger were
inferred from field observations in the literature.
}
\examples{

library(ggplot2)

ggplot(mammals, aes(x = log(body_wt), y = log(brain_wt))) +
  geom_point() +
  geom_smooth(method = "lm") +
  labs(x = "Log of body weight", x = "Log of brain weight")
}
\references{
T. Allison and D. Cicchetti, "Sleep in mammals: ecological and
constitutional correlates," Arch. Hydrobiol, vol. 75, p. 442, 1975.
}
\keyword{datasets}
