% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oa2df.R
\name{works2df}
\alias{works2df}
\title{Convert OpenAlex collection of works from list format to data frame}
\usage{
works2df(
  data,
  abstract = TRUE,
  verbose = TRUE,
  pb = if (verbose) oa_progress(length(data)) else NULL
)
}
\arguments{
\item{data}{List. Output of \code{oa_request}.}

\item{abstract}{Logical. If TRUE, the function returns also the abstract of each item.
Defaults to TRUE.}

\item{verbose}{Logical.
If TRUE, print information about the dataframe conversion process.
Defaults to TRUE.}

\item{pb}{Progress bar object. If verbose, computed from `oa_progress`.
NULL otherwise.}
}
\value{
a data.frame.

For more extensive information about OpenAlex API, please visit: <https://docs.openalex.org>
}
\description{
It converts bibliographic collection of works gathered from OpenAlex database \href{https://openalex.org/}{https://openalex.org/} into data frame.
The function converts a list of works obtained using \code{oa_request} into a data frame/tibble.
}
\examples{
\dontrun{

# Query to search all works citing the article:
#  Aria, M., & Cuccurullo, C. (2017). bibliometrix:
#   An R-tool for comprehensive science mapping analysis.
#   Journal of informetrics, 11(4), 959-975.

#  published in 2021.
#  The paper is associated to the OpenAlex id W2755950973.

#  Results have to be sorted by relevance score in a descending order.

query <- oa_query(
  identifier = NULL,
  entity = "works",
  cites = "W2755950973",
  from_publication_date = "2021-01-01",
  to_publication_date = "2021-12-31",
  search = NULL,
  endpoint = "https://api.openalex.org"
)

res <- oa_request(
  query_url = query,
  count_only = FALSE,
  verbose = FALSE
)

df <- oa2df(res, entity = "works")

df
}

}
