% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/windroseMap.R
\name{windroseMap}
\alias{windroseMap}
\title{Wind rose plots on interactive leaflet maps}
\usage{
windroseMap(
  data,
  latitude = NULL,
  longitude = NULL,
  control = NULL,
  popup = NULL,
  label = NULL,
  provider = "OpenStreetMap",
  cols = "jet",
  alpha = 1,
  key = FALSE,
  iconWidth = 200,
  iconHeight = 200,
  fig.width = 4,
  fig.height = 4,
  type = NULL,
  ...
)
}
\arguments{
\item{data}{A data frame. The data frame must contain the data to plot a
\code{\link[openair:windRose]{openair::windRose()}}, which includes wind speed (\code{ws}), and wind
direction (\code{wd}). In addition, \code{data} must include a decimal
latitude and longitude.}

\item{latitude}{The decimal latitude. If not provided, latitude will be
automatically inferred from data by looking for a column named \dQuote{lat}
or \dQuote{latitude} (case-insensitively).}

\item{longitude}{The decimal longitude. If not provided, longitude will be
automatically inferred from data by looking for a column named
\dQuote{lon}, \dQuote{lng}, \dQuote{long}, or \dQuote{longitude}
(case-insensitively).}

\item{control}{Column to be used for splitting the input data into different
groups which can be selected between using a "layer control" interface.
Appropriate columns could be those added by \code{\link[openair:cutData]{openair::cutData()}} or
\code{\link[openair:splitByDate]{openair::splitByDate()}}.}

\item{popup}{Column to be used as the HTML content for marker popups. Popups
may be useful to show information about the individual sites (e.g., site
names, codes, types, etc.).}

\item{label}{Column to be used as the HTML content for hover-over labels.
Labels are useful for the same reasons as popups, though are typically
shorter.}

\item{provider}{The base map(s) to be used. See
\url{http://leaflet-extras.github.io/leaflet-providers/preview/} for a list
of all base maps that can be used. If multiple base maps are provided, they
can be toggled between using a "layer control" interface.}

\item{cols}{The colours used for plotting.}

\item{alpha}{The alpha transparency to use for the plotting surface (a value
between 0 and 1 with zero being fully transparent and 1 fully opaque).}

\item{key}{Should the key of the plot be drawn. Default is \code{FALSE}.}

\item{iconWidth}{The actual width of the plot on the map in pixels.}

\item{iconHeight}{The actual height of the plot on the map in pixels.}

\item{fig.width}{The width of the plots to be produced in inches.}

\item{fig.height}{The height of the plots to be produced in inches.}

\item{type}{Deprecated. Please use \code{label} and/or \code{popup} to label
different sites.}

\item{...}{Other arguments for \code{\link[openair:windRose]{openair::windRose()}}.}
}
\value{
A leaflet object.
}
\description{
\code{\link[=windroseMap]{windroseMap()}} creates a \code{leaflet} map using wind roses as
markers. Multiple layers of markers can be added and toggled between
using \code{control}. See \code{\link[openair:windRose]{openair::windRose()}} for more information.
}
\examples{
\dontrun{
windroseMap(polar_data,
  provider = "Stamen.Toner"
)
}
}
\seealso{
Directional analysis maps: \code{\link[=annulusMap]{annulusMap()}}, \code{\link[=freqMap]{freqMap()}},
\code{\link[=percentileMap]{percentileMap()}}, \code{\link[=polarMap]{polarMap()}}, \code{\link[=pollroseMap]{pollroseMap()}}, \code{\link[=windroseMap]{windroseMap()}}.
}
