% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{bootMeanDF}
\alias{bootMeanDF}
\title{Bootsrap confidence intervals in the mean}
\usage{
bootMeanDF(x, conf.int = 0.95, B = 1000)
}
\arguments{
\item{x}{A vector from which the mean and bootstrap confidence intervals in
the mean are to be calculated}

\item{conf.int}{The confidence interval; default = 0.95.}

\item{B}{The number of bootstrap simulations}
}
\value{
Returns a data frame with the mean, lower uncertainty, upper
uncertainty and number of values used in the calculation
}
\description{
A utility function to calculation the uncertainty intervals in the mean of a
vector. The function removes any missing data before the calculation.
}
\examples{
test <- rnorm(20, mean = 10)
bootMeanDF(test)
}
