% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_models.R
\name{list_models}
\alias{list_models}
\title{List models}
\usage{
list_models(
  openai_api_key = Sys.getenv("OPENAI_API_KEY"),
  openai_organization = NULL
)
}
\arguments{
\item{openai_api_key}{required; defaults to \code{Sys.getenv("OPENAI_API_KEY")}
(i.e., the value is retrieved from the \code{.Renviron} file); a length one
character vector. Specifies OpenAI API key.}

\item{openai_organization}{optional; defaults to \code{NULL}; a length one
character vector. Specifies OpenAI organization.}
}
\value{
Returns a list, an element of which is a data frame containing
information about models.
}
\description{
Lists the currently available models, and provides basic information about
each one such as the owner and availability. See
\href{https://beta.openai.com/docs/api-reference/models/list}{this page} for
details.
}
\details{
For arguments description please refer to the \href{https://beta.openai.com/docs/api-reference/models/list}{official documentation}.
}
\examples{
\dontrun{
list_models()
}
}
\seealso{
Other model functions: 
\code{\link{retrieve_model}()}
}
\concept{model functions}
