/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.tokenize;

import java.io.IOException;
import opennlp.tools.tokenize.TokenSample;
import opennlp.tools.tokenize.Tokenizer;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.Span;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenizerStream
implements ObjectStream<TokenSample> {
    private Tokenizer tokenizer;
    private ObjectStream<String> input;

    public TokenizerStream(Tokenizer tokenizer, ObjectStream<String> input) {
        this.tokenizer = tokenizer;
        this.input = input;
    }

    @Override
    public TokenSample read() throws IOException {
        String inputString = this.input.read();
        if (inputString != null) {
            Span[] tokens = this.tokenizer.tokenizePos(inputString);
            return new TokenSample(inputString, tokens);
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    @Override
    public void reset() throws IOException, UnsupportedOperationException {
        this.input.reset();
    }
}

