/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats;

import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.params.BasicFormatParams;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.formats.BioNLP2004NameSampleStream;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.util.ObjectStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BioNLP2004NameSampleStreamFactory
extends AbstractSampleStreamFactory<NameSample> {
    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(NameSample.class, "bionlp2004", new BioNLP2004NameSampleStreamFactory(Parameters.class));
    }

    protected <P> BioNLP2004NameSampleStreamFactory(Class<P> params) {
        super(params);
    }

    @Override
    public ObjectStream<NameSample> create(String[] args) {
        Parameters params = ArgumentParser.parse(args, Parameters.class);
        int typesToGenerate = 0;
        if (params.getTypes().contains("DNA")) {
            typesToGenerate |= 1;
        } else if (params.getTypes().contains("protein")) {
            typesToGenerate |= 2;
        } else if (params.getTypes().contains("cell_type")) {
            typesToGenerate |= 4;
        } else if (params.getTypes().contains("cell_line")) {
            typesToGenerate |= 8;
        } else if (params.getTypes().contains("RNA")) {
            typesToGenerate |= 0x10;
        }
        return new BioNLP2004NameSampleStream(CmdLineUtil.openInFile(params.getData()), typesToGenerate);
    }

    static interface Parameters
    extends BasicFormatParams {
        @ArgumentParser.ParameterDescription(valueName="DNA,protein,cell_type,cell_line,RNA")
        public String getTypes();
    }
}

