/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.ext;

import opennlp.tools.util.ext.ExtensionNotLoadedException;
import opennlp.tools.util.ext.OSGiExtensionLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionLoader {
    private static boolean isOsgiAvailable = false;

    private ExtensionLoader() {
    }

    static boolean isOSGiAvailable() {
        return isOsgiAvailable;
    }

    static void setOSGiAvailable() {
        isOsgiAvailable = true;
    }

    public static <T> T instantiateExtension(Class<T> clazz, String extensionClassName) {
        try {
            Class<?> extClazz = Class.forName(extensionClassName);
            if (clazz.isAssignableFrom(extClazz)) {
                try {
                    return (T)extClazz.newInstance();
                }
                catch (InstantiationException e) {
                    throw new ExtensionNotLoadedException(e);
                }
                catch (IllegalAccessException e) {
                    throw new ExtensionNotLoadedException(e);
                }
            }
            throw new ExtensionNotLoadedException("Extension class '" + extClazz.getName() + "' needs to have type: " + clazz.getName());
        }
        catch (ClassNotFoundException e) {
            if (isOsgiAvailable) {
                OSGiExtensionLoader extLoader = OSGiExtensionLoader.getInstance();
                return extLoader.getExtension(clazz, extensionClassName);
            }
            throw new ExtensionNotLoadedException("Unable to find implementation for " + clazz.getName() + ", the class or service " + extensionClassName + " could not be located!");
        }
    }
}

