/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Sequence
implements Comparable {
    private double score;
    private List outcomes;
    private List probs;
    private static final Double ONE = new Double(1.0);

    public Sequence() {
        this.outcomes = new ArrayList(1);
        this.probs = new ArrayList(1);
        this.score = 0.0;
    }

    public Sequence(Sequence s) {
        this.outcomes = new ArrayList(s.outcomes.size() + 1);
        this.outcomes.addAll(s.outcomes);
        this.probs = new ArrayList(s.probs.size() + 1);
        this.probs.addAll(s.probs);
        this.score = s.score;
    }

    public Sequence(Sequence s, String outcome, double p) {
        this.outcomes = new ArrayList(s.outcomes.size() + 1);
        this.outcomes.addAll(s.outcomes);
        this.outcomes.add(outcome);
        this.probs = new ArrayList(s.probs.size() + 1);
        this.probs.addAll(s.probs);
        this.probs.add(new Double(p));
        this.score = s.score + Math.log(p);
    }

    public Sequence(List outcomes) {
        this.outcomes = outcomes;
        this.probs = Collections.nCopies(outcomes.size(), ONE);
    }

    public int compareTo(Object o) {
        Sequence s = (Sequence)o;
        if (this.score < s.score) {
            return 1;
        }
        if (this.score > s.score) {
            return -1;
        }
        return 0;
    }

    public void add(String outcome, double p) {
        this.outcomes.add(outcome);
        this.probs.add(new Double(p));
        this.score += Math.log(p);
    }

    public List getOutcomes() {
        return this.outcomes;
    }

    public double[] getProbs() {
        double[] ps = new double[this.probs.size()];
        this.getProbs(ps);
        return ps;
    }

    public double getScore() {
        return this.score;
    }

    public void getProbs(double[] ps) {
        int pl = this.probs.size();
        for (int pi = 0; pi < pl; ++pi) {
            ps[pi] = (Double)this.probs.get(pi);
        }
    }

    public String toString() {
        return this.score + " " + this.outcomes;
    }
}

