% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datashield.admin.R
\name{dsadmin.profile_perm_add}
\alias{dsadmin.profile_perm_add}
\title{Add or update a permission on a DataSHIELD profile}
\usage{
dsadmin.profile_perm_add(
  opal,
  name,
  subject,
  type = "user",
  permission = "use"
)
}
\arguments{
\item{opal}{Opal connection object.}

\item{name}{Profile.}

\item{subject}{A vector of subject identifiers: user names or group names (depending on the type).}

\item{type}{The type of subject: user (default) or group.}

\item{permission}{The permission to apply: use.}
}
\description{
When adding/updating some permissions on a DataSHIELD profile, this profile
is automatically set in restricted access mode.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
dsadmin.profile_perm_add(o, 'default', c('andrei', 'valentina'), 'user', 'use')
dsadmin.profile_perm(o, 'default')
dsadmin.profile_perm_delete(o, 'default', c('andrei', 'valentina'), 'user')
opal.logout(o)
}
}
\seealso{
Other DataSHIELD profiles: 
\code{\link{dsadmin.profile_access}()},
\code{\link{dsadmin.profile_create}()},
\code{\link{dsadmin.profile_delete}()},
\code{\link{dsadmin.profile_enable}()},
\code{\link{dsadmin.profile_exists}()},
\code{\link{dsadmin.profile_init}()},
\code{\link{dsadmin.profile_perm_delete}()},
\code{\link{dsadmin.profile_perm}()},
\code{\link{dsadmin.profile_rparser}()},
\code{\link{dsadmin.profiles}()},
\code{\link{dsadmin.profile}()}
}
\concept{DataSHIELD profiles}
