% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RsquaredSE.R
\name{RsquaredSE}
\alias{RsquaredSE}
\title{Calculate out-of-sample R² and its standard error based on MSE estimates}
\usage{
RsquaredSE(MSE, margVar, SEMSE, n, corMSEMST)
}
\arguments{
\item{MSE}{An estimate of the mean squared error (MSE)}

\item{margVar}{The marginal variance of the outcome, not scaled by (n+1)/n}

\item{SEMSE}{The standard error on the MSE estimate}

\item{n}{the sample size of the training data}

\item{corMSEMST}{The correlation between MSE and marginal variance estimates}
}
\value{
A vector with the R² and standard error estimates
}
\description{
Calculate out-of-sample R² and its standard error based on MSE estimates
}
\details{
This function is exported to allow the user to estimate the MSE and its standard error
and the correlation between MSE and MST estimators himself.
The marginal variance is scaled by (n+1)/n to the out-of-sample MST, so the user does not need to do this.
}
\examples{
#The out-of-sample R² calculated using externally provided estimates
RsquaredSE(MSE = 3, margVar = 4, SEMSE = 0.4, n = 50, corMSEMST = 0.75)
}
\references{
\insertRef{Hawinkel2023}{oosse}
}
\seealso{
\link{R2oosse}
}
