% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_antecedent_conditions.R
\name{simulate_antecedent_conditions}
\alias{simulate_antecedent_conditions}
\title{simulate_antecedent_conditions}
\usage{
simulate_antecedent_conditions(x, i, j, nsim, heterogenous = FALSE, ...)
}
\arguments{
\item{x}{ppp}

\item{i}{Mark of points that are randomized.}

\item{j}{Mark of points that do not change.}

\item{nsim}{Number of patterns to simulate.}

\item{heterogenous}{If TRUE, points with the mark i are randomized using a heterogeneous
Poisson process.}

\item{...}{Arguments passed to \code{spatstat.core::density.ppp()}.}
}
\value{
list
}
\description{
Simulate heterogenous pattern
}
\details{
Simulate point patterns as null model data for \code{spatstat.core::envelope()} using
antecedent conditions as null model. \code{x} must be marked point pattern.
Antecedent conditions are suitable as a null model if points of type j may influence
points of type i, but not the other way around (Velazquez et al 2016). One example are
the positions of seedlings that may be influenced by the position of mature trees.

Returns a \code{list} with \code{ppp} objects.
}
\examples{
set.seed(42)
pattern_a <- spatstat.core::runifpoint(n = 20)
spatstat.geom::marks(pattern_a) <- "a"
pattern_b <- spatstat.core::runifpoint(n = 100)
spatstat.geom::marks(pattern_b) <- "b"
pattern <- spatstat.geom::superimpose(pattern_a, pattern_b)

null_model <- simulate_antecedent_conditions(x = pattern, i = "b", j = "a", nsim = 19)
spatstat.core::envelope(Y = pattern, fun = spatstat.core::pcf, nsim = 19, simulate = null_model)

}
\references{
Velázquez, E., Martínez, I., Getzin, S., Moloney, K.A., Wiegand, T., 2016. An
evaluation of the state of spatial point pattern analysis in ecology.
Ecography 39, 1–14. https://doi.org/10.1111/ecog.01579

Wiegand, T., Moloney, K.A., 2014. Handbook of spatial point-pattern analysis in
ecology. Chapman and Hall/CRC Press, Boca Raton.
}
\seealso{
\code{\link{envelope}}
}
