% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complete_cases.R
\name{complete_cases}
\alias{complete_cases}
\alias{complete_cases.list}
\alias{complete_cases.data.frame}
\title{Find complete cases in forecast matrices}
\usage{
complete_cases(object, kseq = NA)

\method{complete_cases}{list}(object, kseq = NA)

\method{complete_cases}{data.frame}(object, kseq = NA)
}
\arguments{
\item{object}{A data.frame (with columns named 'kxx') or a list of
data.frames.}

\item{kseq}{integer vector: If given then only these horizons are processed.}
}
\value{
A logical vector specifying if there is no missing
    values across all horizonsd.
}
\description{
Returns a logical vector indicating the time points which
}
\details{
Given a forecast matrix the forecasts are lagged "+k" steps to align them and
then 'complete.cases()' is run on that .

Gieven a list of forecast matrices the points where all are complete (also all horizons) are complete are TRUE.
}
\examples{
# Take a small data set
D <- subset(Dbuilding, 1:20, kseq=1:5)
# Check the forecast matrix of ambient temperature
D$Ta
# Which are complete over all horizons? The first are not since not all horizons
# have a value there (after lagging)
complete_cases(D$Ta)
# Same goes if given as a list
complete_cases(D["Ta"])
# and if more than one is given
complete_cases(D[c("Ta","I")])

# Set some NA of some horizon
D$I$k3[8:9] <- NA
# Now they are recognized as not complete
complete_cases(D[c("Ta","I")])

# If we deal with residuals, which are observations and there for have column names "hxx"
Resid <- residuals(D$Ta, D$Taobs)
names(Resid)
# With columns with "h" instead of "k" no lagging occurs in complete_cases
complete_cases(Resid)
#
Resid2 <- Resid
Resid$h3[8:9] <- NA
complete_cases(list(Resid,Resid2))

}
\author{
Peder Bacher
}
