% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/messages.R
\name{onetime_warning}
\alias{onetime_warning}
\alias{onetime_message}
\alias{onetime_startup_message}
\title{Print a warning or message only once}
\usage{
onetime_warning(
  ...,
  id = calling_package(),
  path = default_lockfile_dir(),
  expiry = NULL,
  without_permission = "warn"
)

onetime_message(
  ...,
  id = calling_package(),
  path = default_lockfile_dir(),
  expiry = NULL,
  without_permission = "warn"
)

onetime_startup_message(
  ...,
  id = calling_package(),
  path = default_lockfile_dir(),
  expiry = NULL,
  without_permission = "warn"
)
}
\arguments{
\item{...}{Passed to \code{\link[=warning]{warning()}}, \code{\link[=message]{message()}} or \code{\link[=packageStartupMessage]{packageStartupMessage()}}.}

\item{id}{Unique ID string. By default, name of the calling package.}

\item{path}{Directory to store lockfiles.}

\item{expiry}{\code{\link[=difftime]{difftime()}} or e.g. \code{\link[lubridate:duration]{lubridate::duration()}} object.
After this length of time, code will be run again.}

\item{without_permission}{Character string. What to do if the user hasn't
given permission to store files? \code{"warn"} runs the action with an extra
warning; \code{"run"} runs the action; \code{"pass"} does nothing and returns the
default; \code{"stop"} throws an error; \code{"ask"} asks for permission, after
running the action but before recording it on disk.}
}
\value{
\code{TRUE} if the message/warning was shown, \code{FALSE} otherwise.
}
\description{
These functions use \code{\link[=onetime_do]{onetime_do()}} to print a warning or message just
once.
}
\examples{
oo <- options(onetime.dir = tempdir(check = TRUE))
id <- sample(10000L, 1)

for (n in 1:3) {
  onetime_warning("will be shown once", id = id)
}

onetime_reset(id = id)
options(oo)
}
\seealso{
\code{\link[=onetime_do]{onetime_do()}}
}
