% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_theme_info.R
\name{get_theme_info}
\alias{get_theme_info}
\title{Get Theme Information}
\usage{
get_theme_info(token, theme)
}
\arguments{
\item{token}{User's API token. This can be retrieved using \code{\link{get_token}}}

\item{theme}{Query name of theme. Themes’ query names can be retrieved using \code{\link{search_themes}}.}
}
\value{
A named character vector of Theme Name and Query Name.
If an error occurred, the function returns \code{NULL} along with a warning message.
}
\description{
This function is a wrapper for the \href{https://docs.onemap.sg/#get-theme-info}{Get Theme Info API}. It returns a named character vector of Theme Name and Query Name.
}
\examples{
# returns named character vector
\dontrun{get_theme_status(token, "kindergartens")}

# returns NULL, warning message shows status code
\dontrun{get_theme_status("invalid_token", "blood_bank")}

# returns NULL, warning message shows error
\dontrun{get_theme_status(token, "invalid_theme")}
}
