% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{filter_prob}
\alias{filter_prob}
\title{Function filter genotypes by genotype probability}
\usage{
filter_prob(onemap.obj = NULL, threshold = 0.8, verbose = TRUE)
}
\arguments{
\item{onemap.obj}{an object of class \code{onemap}.}

\item{threshold}{a numeric from 0 to 1 to define the threshold for 
the probability of the called genotype (highest probability)}

\item{verbose}{If \code{TRUE}, print tracing information.}
}
\value{
An object of class \code{onemap}, i.e., a list with the following
components: \item{geno}{a matrix with integers indicating the genotypes
read for each marker. Each column contains data for a marker and each row
represents an individual.} \item{n.ind}{number of individuals.}
\item{n.mar}{number of markers.} \item{segr.type}{a vector with the
segregation type of each marker, as \code{strings}.} \item{segr.type.num}{a
vector with the segregation type of each marker, represented in a
simplified manner as integers, i.e. 1 corresponds to markers of type
\code{"A"}; 2 corresponds to markers of type \code{"B1.5"}; 3 corresponds
to markers of type \code{"B2.6"}; 4 corresponds to markers of type
\code{"B3.7"}; 5 corresponds to markers of type \code{"C.8"}; 6 corresponds
to markers of type \code{"D1"} and 7 corresponds to markers of type
\code{"D2"}. Markers for F2 intercrosses are coded as 1; all other crosses
are left as \code{NA}.} \item{input}{the name of the input file.}
\item{n.phe}{number of phenotypes.} \item{pheno}{a matrix with phenotypic
values. Each column contains data for a trait and each row represents an
individual.} \item{error}{matrix containing HMM emission probabilities}
}
\description{
Function filter genotypes by genotype probability
}
\examples{
\donttest{
  data(onemap_example_out)
  filt_obj <- filter_prob(onemap_example_out, threshold=0.8)
 }
}
\author{
Cristiane Taniguti, \email{chtaniguti@tamu.edu}
}
