\name{draw.map}
\alias{draw.map}
\title{Draw a genetic map}
\description{
  Provides a simple draw of a genetic map.
}
\usage{
draw.map(map.list, horizontal=FALSE, names=FALSE, grid=FALSE, cex.mrk=1, cex.grp=.75)
}

\arguments{
  \item{map.list}{a map, i.e. an object of class \code{sequence} with a
    predefined order, linkage phases, recombination fraction and
    likelihood; also it could be a list of maps.}
  \item{horizontal}{if \code{TRUE}, indicates that the map should be plotted
    horizontally. Default is \code{FALSE}}
  \item{names}{if \code{TRUE}, displays the names of the markers. Default is \code{FALSE}}
  \item{grid}{if \code{TRUE}, displays a grid in the background. Default is \code{FALSE}}
  \item{cex.mrk}{the magnification to be used for markers.}
  \item{cex.grp}{the magnification to be used for group axis annotation.}
}

\author{Marcelo Mollinari, \email{mmollina@usp.br}}
%\seealso{ }
\examples{
\dontrun{
 #outcross example
  data(example.out)
  twopt <- rf.2pts(example.out)
  lg<-group(make.seq(twopt, "all"))
  maps<-vector("list", lg$n.groups)
  for(i in 1:lg$n.groups)
     maps[[i]]<- make.seq(order.seq(input.seq= make.seq(lg,i),twopt.alg =
   "rcd"), "force")
  draw.map(maps, grid=TRUE)
  draw.map(maps, grid=TRUE, horizontal=TRUE)

  #F2 example
  data(fake.f2.onemap)
  twopt<-rf.2pts(fake.f2.onemap)
  lg<-group(make.seq(twopt, "all"))
  maps<-vector("list", lg$n.groups)
  for(i in 1:lg$n.groups)
     maps[[i]]<- make.seq(order.seq(input.seq= make.seq(lg,i),twopt.alg =
   "rcd"), "force")
  draw.map(maps, grid=TRUE)
  draw.map(maps, grid=TRUE, horizontal=TRUE)

}
}

\keyword{rqtl}
