% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/omu_anova.R
\name{omu_anova}
\alias{omu_anova}
\title{Perform anova}
\usage{
omu_anova(
  count_data,
  metadata,
  response_variable = "Metabolite",
  model,
  log_transform = FALSE,
  method = "anova"
)
}
\arguments{
\item{count_data}{A metabolomics count data frame}

\item{metadata}{Metadata dataframe for the metabolomics count data frame}

\item{response_variable}{String of the column header for the response variables,
usually "Metabolite"}

\item{model}{A formual class object, see ?formula for more info on formulas in R.
an interaction between independent variables. Optional parameter}

\item{log_transform}{Boolean of TRUE or FALSE for whether or not you wish to log transform
your metabolite counts}

\item{method}{A string of 'anova', 'kruskal', or 'welch'. anova performs an anova with a post hoc
tukeys test, kruskal performs a kruskal wallis with a post hoc dunn test, welch performs a
welch's anova with a post hoc games howell test}
}
\description{
Performs an anova across all response variables, followed by a Tukeys test on every possible
contrast in your model and calculates group means and fold changes for each contrast. Returns a list of
data frames for each contrast, and includes a dataframe of model residuals
}
\examples{
\dontshow{c57_nos2KO_mouse_countDF <- c57_nos2KO_mouse_countDF[1:12,];
c57_nos2KO_mouse_metadata <- c57_nos2KO_mouse_metadata;}
anova_df <- omu_anova(count_data = c57_nos2KO_mouse_countDF, metadata = c57_nos2KO_mouse_metadata,
response_variable = "Metabolite", model = ~ Treatment, log_transform = TRUE)

anova_df <- omu_anova(count_data = c57_nos2KO_mouse_countDF, metadata = c57_nos2KO_mouse_metadata,
response_variable = "Metabolite", model = ~ Treatment + Background, log_transform = TRUE)

anova_df <- omu_anova(count_data = c57_nos2KO_mouse_countDF, metadata = c57_nos2KO_mouse_metadata,
response_variable = "Metabolite", model = ~ Treatment + Background + Treatment*Background,
log_transform = TRUE)

}
