% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-api.R
\name{nvars}
\alias{nvars}
\title{Number of variables of a model}
\usage{
nvars(model)
}
\arguments{
\item{model}{the model}
}
\value{
a list with three named elements.
        'binary' => number of binary variables,
        'integer' => number of integer variables,
        'continuous' => number of continuous variables.
}
\description{
Number of variables of a model
}
\examples{
library(magrittr)
model <- MIPModel() \%>\%
  add_variable(x[i], i = 1:10, type = "binary") \%>\%
  add_variable(y[i], i = 1:5, type = "continuous") \%>\%
  add_variable(z[i], i = 1:2, type = "integer")
nvars(model)
}
